﻿$(function() {
	creatGrid();
	$('#courseClassifyCombx').combotree({
		multiple : false,
		checkbox : false,
		lines : true,
		animate : true,
		editable : false,//不可编辑
		onHidePanel : getChildren,//获取子节点
		url : baseUrl + '/admin/B020/listCoursewareClassifyTree.html',
		required : false
	});
	//试题分类
	$('#searchclassify').combotree({
		multiple : false,
		checkbox : false,
		lines : true,
		animate : true,
		editable : false,
		panelMinWidth:200,
		panelMaxWidth:300,
		panelMaxHeight:200,
		url : baseUrl + '/admin/B010/listFindQsnClassifyAddALL.html',
		required : false
	});
	//题型
	$('#searchshititype').combobox({
		url :baseUrl + '/admin/B010/listFindQuestionsTypeAddAll.html',
		editable : false,
		required : false,
		panelMinWidth:200,
		panelMaxWidth:300,
		panelMaxHeight:200,
		valueField : 'sttypeid',
		textField : 'name'
	});
	$(".panel-tool-close").click(function(){
		reloadGrid();
	});
});
/**
 * easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatGrid() {
	$('#coursewareList').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据sort。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl + '/admin/C020/listCoursewares.html',
		toolbar : '#tbar',
		frozenColumns : [ [ {
			field : 'select',
			title : 'select',
			width : 50,
			checkbox : true
		} ] ],
		columns : [ [ {
			field : 'coursewareName',
			title : 'courseware Name',
			width : 120,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'hiddenId',
			title : 'courseware Id',
			hidden:true
		}, {
			field : 'type',
			title : 'classify Name',
			width : 45,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'classifyName',
			title : 'classify Name',
			width : 80,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'timelength',
			title : 'time length (min)',
			width : 30,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'right'
	
		}, {
			field : 'shitiCount',
			title : 'question quantity',
			width : 45,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'right',
			formatter : shitiCount
	
		}, {
			field : 'userName',
			title : 'user name',
			width : 70,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'updDate',
			title : 'updated Date',
			width : 80,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'center',
			formatter : fmdate
		},
		{
			field : 'typeId',
			title : 'classify Name ID',
			hidden:true
		},
		{
			field : 'manage',
			title : 'manage',
			halign: 'right',
			align : 'right',
			width :110,
			formatter : operate
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.add_shiti').linkbutton({
				iconCls : 'icon-add',
				plain : true
			});
			$('.edit_courseware').linkbutton({
				iconCls : 'icon-edit',
				plain : true
			});
			$('.drop_courseware').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});
		}
	});
}
//sort
function datasort(a, b) {
	return (a > b ? 1 : -1);
}
//操作
function operate(value, rowData, rowIndex) {
	var id=rowData.coursewareId;
	var typeId=rowData.typeId;
	//视频时长
	var timeLength=rowData.timelength;
	var buttonStr=" ";
	if(typeId==1||typeId==2){
		buttonStr+="<a href='javascript:void(0);' onclick='addShiTi("+id+","+timeLength+");' class='add_shiti'>binding questions</a>";
	}
	buttonStr+="<a href='javascript:void(0)' onclick='updInfo("+id+");' class='edit_courseware'>edit</a><a href='javascript:void(0);' onclick='delById("+id+");' class='drop_courseware' >delete</a>";
	return buttonStr;
}
//操作
function shitiCount(value, rowData, rowIndex) {
	var coursewareId=rowData.coursewareId;
	var shitiCount=rowData.shitiCount;
	return "<a href='javascript:void(0);' onclick='openChoosedShitiPop("+coursewareId+")'>"+shitiCount+"</a>";
}

//打开页面
function addCourseware(){
	window.parent.openTab("Add Courseware ", baseUrl + "/admin/C020/manageSaveCourseware.html");
}
//格式化日期
function fmdate(value, rowData, rowIndex) {
	if (value != null && value != '') {
		return fmtLongDate(new Date(value));
	}
	return "";
}
function findCourseware(){
	//课件名称
	var coursewareName=$("#coursewareName").val();
	//课件分类
	//var coursewareClassify=$("#courseClassifyCombx").combotree("getValue");
	//学时（分）开始
	var studyTimeStart=$("#periodStart").datebox("getValue");
	//学时（分）结束
	var studyTimeEnd=$("#periodEnd").datebox("getValue");

	var coursewareClassify=classifyids;//全局变量 所有分类ID的值集合字符串
	var dateStart=$("#updateTimeStart").next().find(".textbox-value").val();
	var dateEnd=$("#updateTimeEnd").next().find(".textbox-value").val();
	$('#coursewareList').datagrid('load', {    
		coursewareName: coursewareName,
		classifyid:coursewareClassify,
		timeLengthStart:studyTimeStart,
		timeLengthEnd:studyTimeEnd,
		dateStart:dateStart,
		dateEnd:dateEnd
	});
}
//刷新
function reloadGrid() {
	$('#coursewareList').datagrid('clearSelections');
	$('#coursewareList').datagrid('reload');
}

// 删除课件
function delCourseware() {
	var items_id = new Array();
	var items = $('#coursewareList').datagrid('getSelections');
	if (items.length <= 0) {
		$.messager.alert('Hint', 'Please select the courseware need deleted', 'info');
		return;
	}
	$.messager.confirm('delete Hint', 'Make sure to delete the selected courseware?</br></br><input type="checkbox" id="yuanwenjian" name="checkbox1" value="1" /> Delete the local source file', function(r) {
		if (r) {
			var str=document.getElementsByName("checkbox1");
			var objarray=str.length;
			var chestr=0;
			for (var i=0;i<objarray;i++) {
			 if(str[i].checked == true)
			 {
			  chestr =str[i].value;
			 }
			}
			// 获取选中课件的ID，并组成集合
			for ( var i = 0; i < items.length; i++) {
				items_id.push(items[i].coursewareId);
			}
			$.post(baseUrl + "/admin/C020/removeCourseware.html", {
				cid : items_id,
				typeid:chestr
			}, function(data) {
				if (data > 0) {
					msgShow('delete success!');
					reloadGrid();
				}else if(data = -1){
					msgShow('delete failure，courseware is being used');
					reloadGrid();
				} else {
					msgShow('delete failure，Please try again later');
					reloadGrid();
				}
			}, "json");
		}
	});
}

//根据ID删除
function delById(id) {
	var items_id = new Array();
	items_id.push(id);
	$.messager.confirm('delete Hint', 'Make sure to delete this courseware?</br></br><input type="checkbox" id="yuanwenjian" name="checkbox1" value="1" /> Delete the local source file', function(r) {
		if (r) {
			var str=document.getElementsByName("checkbox1");
			var objarray=str.length;
			var chestr=0;
			for (var i=0;i<objarray;i++) {
			 if(str[i].checked == true)
			 {
			  chestr =str[i].value;
			 }
			}
			$.post(baseUrl + "/admin/C020/removeCourseware.html", {
				cid :items_id,
				typeid:chestr
			}, function(data) {
				if (data > 0) {
					msgShow('Delete success!');
					reloadGrid();
				}else if(data = -1){
					msgShow('delete failure，courseware is used');
					reloadGrid();
				}else {
					msgShow('delete failure，Please try again later');
					reloadGrid();
				}
			}, "json");
		}
	});
}
/**
 * 试题列表easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatShitiGrid(cid) {
	$('#shitiList').datagrid(
		{
			fit : true,// 设置为true时铺满它所在的容器.
			fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
			nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
			striped : true,// 设置为true将交替显示行背景。
			collapsible : true,// 定义是否显示可折叠按钮。
			singleSelect : true,// 设置为true将只允许选择一行。
			border : false,
			remoteSort : false,// 定义是否通过远程服务器对数据sort。
			pagination : true,// 分页组件是否显示
			pageNumber : 1,// 起始页
			pageSize : 10,// 每页显示的记录条数，默认为10
			pageList : [ 10, 20, 50 ,100,300,500],// 每页显示多少行
			rownumbers : true,// 行号
			url : baseUrl + "/admin/C020/listQuestion.html",
			queryParams: {coursewareId: cid},
			toolbar : '#shitiBar',
			frozenColumns : [ [ {
				field : 'select',
				title : 'select',
				width : 50,
				checkbox : true
			} ] ],
			columns : [ [ {
				field : 'title',
				title : 'title',
				width : 200,
				fixed : true,
				align : 'left',
				sortable : true,
				sorter : datasort,
				formatter:titleLength
			}, {
				field : 'classifyname',
				title : 'classify name',
				width : 80,
				sortable : true,
				sorter : datasort,
				align : 'left'
			}, {
				field : 'shititypename',
				title : 'question type',
				width : 80,
				sortable : true,
				sorter : datasort,
				align : 'left'
			}, {
				field : 'insdate',
				title : 'creation date',
				width : 100,
				align : 'center',
				sortable : true,
				sorter : datasort,
				formatter : fmdate
			}, {
				field : 'username',
				title : 'user name',
				width : 80,
				align : 'center',
				sortable : true,
				sorter : datasort
			}, {
				field : 'option',
				title : 'option',
				hidden:true
				
			}, {
				field : 'shititypeid',
				title : 'question type',
				hidden:true
			}, {
				field : 'qsnid',
				title : 'question ID',
				hidden:true
			}
			] ]
		});

}
function createChoosedShitiGrid(coursewareId) {
	$('#choosedshitiList').datagrid(
		{
			fit : true,// 设置为true时铺满它所在的容器.
			fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
			nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
			striped : true,// 设置为true将交替显示行背景。
			collapsible : true,// 定义是否显示可折叠按钮。
			singleSelect : false,// 设置为true将只允许选择一行。
			border : false,
			remoteSort : false,// 定义是否通过远程服务器对数据排序。
			pagination : true,// 分页组件是否显示
			pageNumber : 1,// 起始页
			pageSize : 10,// 每页显示的记录条数，默认为10
			pageList : [ 10, 20, 50 ,100,300,500],// 每页显示多少行
			rownumbers : true,// 行号
			url : baseUrl + "/admin/C020/listChoosedShiti.html",
			queryParams: {coursewareId: coursewareId},
			frozenColumns : [ [ {
				field : 'select',
				title : 'select',
				width : 50,
				checkbox : true
			} ] ],
			columns : [ [ {
				field : 'title',
				title : 'title',
				width : 200,
				fixed : true,
				align : 'left',
				sortable : true,
				sorter : datasort,
				formatter:titleLength
			}, {
				field : 'minuteBegin',
				title : 'begin time(min)',
				width : 80,
				sortable : true,
				sorter : datasort,
				align : 'center'
			}, {
				field : 'classifyname',
				title : 'classify name',
				width : 80,
				sortable : true,
				sorter : datasort,
				align : 'left'
			}, {
				field : 'shititypename',
				title : 'test type',
				width : 80,
				sortable : true,
				sorter : datasort,
				align : 'left'
			}, {
				field : 'insdate',
				title : 'creation date',
				width : 130,
				align : 'center',
				sortable : true,
				sorter : datasort,
				formatter : fmdate
			}, {
				field : 'username',
				title : 'user name',
				width : 80,
				align : 'center',
				sortable : true,
				sorter : datasort
			},
			{
				field : 'manage',
				title : 'manage',
				halign: 'center',
				align : 'center',
				width :80,
				formatter : delShiTiFmt
			} 
			] ],
			// 当数据载入成功时触发。
			onLoadSuccess : function(data) {
				$('.drop_shiti').linkbutton({
					iconCls : 'icon-no',
					plain : true
				});
			}
		});

}
function delShiTiFmt(value, rowData, rowIndex){
	//操作
	var cid=rowData.coursewareId;
	var qsnid=rowData.qsnid;
	return "<a href='javascript:void(0);' class='drop_shiti' onclick='delShiti("+cid+","+qsnid+")'>delete</a>";
	
}
//删除
function delShiti(cid,qid){
	$.messager.confirm('delete Hint', 'Make sure to delete the selected test?', function(r) {
		if (r) {
			$.ajax({
				url:baseUrl + '/admin/C020/removeShiti.html',
				data:{coursewareId:cid,shitiId:qid},
				type: 'post',
				dataType: 'json',
				success:function(data){
					if(data>0){
						alert("Delete success！");
					}else{
						alert("delete failure！");
					}
					$('#choosedshitiList').datagrid('clearSelections');
					$('#choosedshitiList').datagrid('reload');
				}
			});
			
		}
	});
}
function findShiti(){
	//试题名称
	var title=$("#searchtitle").val();
	//试题分类
	var shitiClassify=$("#searchclassify").combotree("getValue");
	//题型
	var shitiType=$("#searchshititype").combobox("getValue");
	$('#shitiList').datagrid('load', {
		title: title,
		classifyid:shitiClassify,
		shititypeid:shitiType
	});
}
/**
 * 编辑课件
 */
function updInfo(id){
	window.parent.closeTabByTitle("Edit Courseware");
	window.parent.openTab("Edit Courseware", baseUrl + "/admin/C020/manageFindUpdCourseware.html?id="+id);
}
//打开试题窗口
function addShiTi(id,timelength){
	$("#coursewareId").val(id);
	$("#timeLength").val(timelength);
	creatShitiGrid(id);
	$("#minuteBegin").numberbox("clear");
	$('#chooseShitiPop').window('open');
}
//打开试题窗口
function openChoosedShitiPop(id){
	createChoosedShitiGrid(id);
	$('#choosedShitiPop').window('open');
}
function titleLength(value, rowData, rowIndex){
	var strArray=value.split("<img");
	var res=value;
	if(strArray.length > 0){
		for(var i=0;i<strArray.length;i++){
			var str=strArray[i];
			if(str.indexOf("src")>0){
				str=str.substr(0,str.indexOf("/>")+2);
				var imgStr="<img"+str;
				res=res.replace(imgStr,"[Image file]");
			}
		}
	}
	var spanArray = value.split("<span");
	if (spanArray.length > 0){
		for (var i=0;i<spanArray.length;i++){
			var str = spanArray[i];
			if (str.indexOf("style")>0){
				str=str.substr(0,str.indexOf(">")+1);
				var spanStr = "<span"+str;
				res=res.replace(spanStr,"");
			}
		}
	}
	var vArray=res.split("<video");
	if(vArray.length > 0){
		for(var i=0;i<vArray.length;i++){
			var str=vArray[i];
			if(str.indexOf("/video")>0){
				str=str.substr(0,str.indexOf("</video>")+8);
				var vStr="<video"+str;
				res=res.replace(vStr,"[Video file]");
			}
		}
	}
	var wvArray = res.split("<embed");
	if(wvArray.length > 0){
		for(var i=0;i<wvArray.length;i++){
			var str=wvArray[i];
			if(str.indexOf("type")>0){
				str=str.substr(0,str.indexOf("/>")+2);
				var vStr="<embed"+str;
				res=res.replace(vStr,"[video file]");
			}
		}
	}
	if(res.length>15){
		return res.substr(0,15);
	}
	return res;
}
/**
 * 课件试题
 */
function fmtCoursewareShitiJson(){
	var result=[];
	var addedItems=$('#shitiList').datagrid('getSelections');
	if(addedItems.length==0){
		alert("Please select one test。");
		return ;
	}
		var title =addedItems[0].title;
		var qsnid=addedItems[0].qsnid;
		var options =addedItems[0].options;
		var type=addedItems[0].shititypeid+"";
		var daan=addedItems[0].daan;
		var optionsJson=eval("("+options+")");
		var shitiJson={};
		if(type!=3){
			var optionArray=[];
			for(var item in optionsJson){
				option={"value":item,"name":optionsJson[item].xx};
				optionArray.push(option);
			}
			shitiJson={"title":title,"options":optionArray,"answer":daan,"type":type};
		}else{
			shitiJson={"title":title,"answer":daan,"type":type};
		}
		result.push(qsnid);
		result.push(JSON.stringify(shitiJson));
	return result;
}
/**
 * 保存课件绑定的试题
 */
function saveCoursewareShiti(){
	var minuteBegin=$("#minuteBegin").numberbox('getValue');
	var timeLength=$("#timeLength").val();
	if(minuteBegin==""){
		alert("Please fill the ！");
		$("#minuteBegin").focus();
		return false;
	}
	if(parseInt(minuteBegin)>parseInt(timeLength)){
		alert("the video will last"+timeLength+"minutes，minute begin can not be longer than the video。");
		$("#minuteBegin").focus();
		return false;
	}
//	var validMinte = $("#minuteBegin").validatebox('isValid');  
//	if(!validMinte){
//		alert("Fill time error，Please refill again");
//		return false;
//	}
	var result=fmtCoursewareShitiJson();
	var qsnid=result[0];
	var shitiJsonStr=result[1];
	var coursewareId=$("#coursewareId").val();
	var checkIsRepeat=0;
	$.ajax({
		url: baseUrl + '/admin/C020/checkMinuteBeginIsRepeat.html',
		async:false,
		data:{coursewareId:coursewareId,minuteBegin:minuteBegin},
		type: 'post',
		dataType: 'json',
		success:function(data){
			checkIsRepeat=data;
			reloadGrid();
		}
	});
	if(checkIsRepeat>0){
		alert("Minute begin can not repeated。");
		$("#minuteBegin").focus();
		return false;
	}
	$.ajax({
		url: baseUrl + '/admin/C020/saveShiti.html',
		data:{coursewareId:coursewareId,shitiId:qsnid,minuteBegin:minuteBegin,shitiJson:shitiJsonStr},
		type: 'post',
		dataType: 'json',
		success:function(data){
			if(data>0){
				alert("storage suceed！");
			}else{
				alert("storage fail！");
			}
			reloadGrid();
			$('#chooseShitiPop').window('close');
		}
	});
}
function closeWin(){
	$('#choosedShitiPop').window('close');
	reloadGrid();
}
/**
 * 发布课程
 */
function releaseCourse(){
	var items=$('#coursewareList').datagrid('getSelections');
	if(items.length==0){
		$.messager.alert('Hint', "Please select courseware", 'info');
		return;
	}
	var coursewareIds="";
	for(var i=0;i<items.length;i++){
		coursewareIds+=items[i].coursewareId+",";
	}
	var cwIds=coursewareIds.substr(0,coursewareIds.length-1);
	window.parent.openTab("Add Course", baseUrl + "/admin/C010/manageCourseLoad.html?cwIds="+cwIds);
}
var classifyids="";//全局变量
function getChildren() {
	var grouptree = $('#courseClassifyCombx').combotree('tree');//对应combotreeID
	var n = grouptree.tree('getSelected');
	var ids=n.id;
	var items=n.children;
	if(items!=null){
		var children = grouptree.tree('getChildren', n.target);
		for(var i=0;i<children.length;i++){
			var item=children[i];
			ids=ids+","+item.id;
		}
	}
	classifyids=ids;//赋值给全局变量 记录所选分类全部ID
}